// Autor: Frane Kurtovic

#include <iostream>
#include <vector>
#include <string>
#include <cstring>
#include <algorithm>

using namespace std;

const int MAX_N = 101;
const int INF = MAX_N + 1;

string x;
int n;
vector <string> blocks;
int len;
string next_block[MAX_N];
int mem[MAX_N];

int solve(int k) {
  if (k == len) {
    return 0;
  }
  if (mem[k] != -1) return mem[k];
  string suffix = x.substr(k);
  int ret = INF;
  string block, how;
  for (auto block : blocks) {
    if (suffix.size() >= block.size()) {
      if (suffix.substr(0, block.size()) == block) {
        int val = solve(k + block.size());
        if (val < ret) {
          ret = val;
          how = block;
        }
      }
    } else {
      if (suffix == block.substr(0, suffix.size())) {
        ret = 0;
        how = block;
      }
    }
  }
  next_block[k] = how;
  return mem[k] = ret + 1;
}

bool is_prefix(const string &big, const string &x) {
  if (x.size() > big.size()) return 0;
  return big.substr(0, x.size()) == x;
}

void taskB() {
  memset(mem, -1, sizeof(mem));
  for (int i = 0; i < n; i++) {
    string b;
    cin >> b;
    blocks.push_back(b);
  }
  cin >> x;
  len = (int)x.size();
  for (auto b : blocks) {
    if (b.find(x) != string::npos) {
      cout << 1 << endl << b << endl;
      return;
    }
  }
  int best_val = INF;
  string start, start_p;
  for (string block : blocks) {
    for (int i = block.size() - 1; i >= 0; i--) {
      string first = block.substr(i);
      if (is_prefix(x, first)) {
        int val = solve(first.size()) + 1;
        if (val < best_val) {
          best_val = val;
          start = first;
          start_p = block;
        }
      }
    }
  }
  cout << best_val << endl << start_p;
  vector <string> words;
  for (int i = start.size(); i < len; i += next_block[i].size()) {
    cout << "|" << next_block[i];
  }
  cout << endl;
}

int solve(const vector <string>& u, const string& x) {
  int x_len = (int)x.size();
  vector <bool> covered(x_len);
  for (const auto& u_i : u) {
    for (int pos = 0; pos + u_i.size() <= x_len ; pos++) {
      if (x.substr(pos, u_i.size()) == u_i) {
        for (int c_pos = pos; c_pos < pos + u_i.size(); c_pos++) {
          covered[c_pos] = true;
        }
      }
    }
  }
  for (bool c : covered) {
    if (!c) return false;
  }
  return true;
}

void taskA() {
  vector <string> u;
  for (int i = 0; i < n; i++) {
    string x;
    cin >> x;
    u.push_back(x);
  }
  int m;
  cin >> m;
  for (int i = 0; i < m; i++) {
    string x;
    cin >> x;
    cout << solve(u, x);
  }
  cout << endl;
}

int main() {
  cin >> n;
  taskA();
  taskB();

  return 0;
}
